import pandas as pd
import scipy.stats as stats
import pickle

atp_tennis = pd.read_csv("atp_tennis.csv")

trend_results = {}   
for surface in ['Hard', 'Clay', 'Grass']:   
    surface_data = yearly_surface_data[yearly_surface_data['Surface'] == surface]   
    slope, intercept, r_value, p_value, std_err = stats.linregress(surface_data['Year'], surface_data['Win_Loss_Ratio'])   
    trend_results[surface] = {'Slope': slope, 'P-value': p_value}     

# Print the trend analysis results for each surface type   
print("Trend Analysis Results:")   
for surface, result in trend_results.items():   
    print(f"{surface}: Slope = {result['Slope']}, P-value = {result['P-value']}")   
    pickle.dump(result['Slope'],open("./ref_result/Slope_" + surface + ".pkl","wb"))
    pickle.dump(result['P-value'],open("./ref_result/P-value" + surface + ".pkl","wb"))